#include "DAplicacion.h"
#include "DBaseWnd.h"
#include "DSistema.h"
#include <CommCtrl.h>

#pragma comment(lib, "Comctl32.lib")		// Libreria para InitCommonControlEx


namespace DWL {

    DAplicacion *_APLICACION = NULL;

    DSistema Sistema;

    DAplicacion::DAplicacion(void) : _Estado(DEnum_EstadoAplicacion_Uninicializada), _Terminar(false) {
        // Obtengo el path de la aplicacin y lo guardo en la variable _AppPath
	    TCHAR PathApp[MAX_PATH + 1];
	    DWORD Tam = GetModuleFileName(NULL, PathApp, MAX_PATH + 1);
        for (Tam; Tam > 0; Tam --) {
		    if (PathApp[Tam] == TCHAR('\\')) break;
        }
        PathApp[Tam + 1] = 0;
	    _AppPath = PathApp;
    }

    DAplicacion::~DAplicacion(void) {
    }


    const int DAplicacion::Ejecutar(void) {
/*		INITCOMMONCONTROLSEX Comm;
		Comm.dwSize = sizeof(INITCOMMONCONTROLSEX);
		Comm.dwICC = ICC_STANDARD_CLASSES;
		InitCommonControlsEx(&Comm);*/
        Sistema._Iniciar();

        _APLICACION->_Estado = DEnum_EstadoAplicacion_Empezando;
        _APLICACION->Evento_Empezar();
        _APLICACION->_Estado = DEnum_EstadoAplicacion_Funcionando;
        _APLICACION->Evento_BuclePrincipal();
        _APLICACION->_Estado = DEnum_EstadoAplicacion_Cerrando;
        int Ret = _APLICACION->Evento_Terminar();
        return Ret;
    }

    const int DAplicacion::Eventos_Esperar(void) {
        static MSG Msg;
        if (GetMessage(&Msg, NULL, 0, 0) == 0) 
            _Terminar = true; // Se ha hecho un PostQuitMessage
        TranslateMessage(&Msg); 
        DispatchMessage(&Msg);
        return static_cast<int>(Msg.wParam);
    }

    void DAplicacion::Eventos_Mirar(void) {
        static MSG Msg;
        PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE);
        TranslateMessage(&Msg); 
        DispatchMessage(&Msg);
    }

    const size_t DAplicacion::_AgregarBaseWnd(DBaseWnd *nBaseWnd, const DEnum_TipoBaseWnd nTipo, const UINT nID, DBaseWnd *nPadre) {
        _BaseWnd.push_back(DTipoBaseWnd(nBaseWnd, nTipo, nID, nPadre));
        return _BaseWnd.size();
    }

    const size_t DAplicacion::_EliminarBaseWnd(DBaseWnd *nBaseWnd) {
        for (size_t i = _BaseWnd.size(); i > 0; i--) {
            if (_BaseWnd[i - 1].BaseWnd == nBaseWnd || _BaseWnd[i - 1].Padre == nBaseWnd) {
                _BaseWnd.erase(_BaseWnd.begin() + (i -1));
            }
        }

        // Compruebo si queda alguna ventana padre
        if (_BaseWnd.size() == 0) Evento_TerminarGUI();
        return _BaseWnd.size();
    }

    const DEnum_TipoBaseWnd DAplicacion::_ObtenerTipoBaseWnd(const UINT cID) {
        for (size_t i = 0; i < _BaseWnd.size(); i++) {
            if (_BaseWnd[i].ID == cID) return _BaseWnd[i].Tipo;
        }
        return DEnum_TipoBaseWnd_Indefinido;
    }
};